/*
	Computerized Infrared Remote
	Earle F. Philhower, III
	(c) 1996

	Windows 3.1 DLL Example Code
	
	Software to control the CIR hardware module.  Modifications to:
	earle@geocities.com
*/

/****************************************************************************

    PROGRAM: IRWIN

    PURPOSE: Demonstrates IRDLL library

    FUNCTIONS:

    WinMain()         - calls initialization function, processes message loop
    InitApplication() - initializes window data and registers window
    InitInstance()    - saves instance handle and creates main window
    MainWndProc()     - processes messages
    About()           - processes messages for "About" dialog box

****************************************************************************/

#include <windows.h>
#include <commdlg.h>
#include <memory.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include "resource.h"

#include "irdll.h"

HANDLE hInst;

char str[255];                          // general-purpose string buffer


BOOL OpenFileDialog(HWND hWnd, LPSTR fname, LPSTR title);
BOOL SaveFileDialog(HWND hWnd, LPSTR fname, LPSTR title);
long FAR PASCAL __export MainWndProc();
void OFNInit();

/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
    MSG msg;

    if (!hPrevInstance)
        if (!InitApplication(hInstance))
            return (FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

	OFNInit();

    while (GetMessage(&msg, NULL, NULL, NULL))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return (msg.wParam);
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;
{
    WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "MenuBar";
    wc.lpszClassName = "IRWClass";

    return (RegisterClass(&wc));
}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

****************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
HANDLE          hInstance;
int             nCmdShow;
{
    HWND            hWnd;

    hInst = hInstance;

    strcpy(str,"");


    hWnd = CreateWindow("IRWClass",
                        "IRDLL Sample Application",
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        NULL,
                        NULL,
                        hInstance,
                        NULL);

    if (!hWnd)
        return (FALSE);

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return (TRUE);

}

/****************************************************************************

    FUNCTION: MainWndProc(HWND, UINT, WPARAM, LPARAM)

    PURPOSE:  Processes messages

    MESSAGES:

    WM_COMMAND          - application menu (About dialog box)
        WM_CHAR         - ASCII key value received
        WM_LBUTTONDOWN  - left mouse button
        WM_MOUSEMOVE    - mouse movement
        WM_LBUTTONUP    - left button released
        WM_KEYDOWN      - key pressed
        WM_KEYUPS       - key released
        WM_PAINT        - update window
    WM_DESTROY          - destroy window

    COMMENTS:

        When the left mouse button is pressed, btrack is set to TRUE so that
        the code for WM_MOUSEMOVE will keep track of the mouse and update
        the box accordingly.  Once the button is released, btrack is set to
        FALSE, and the current position is saved.  Holding the SHIFT key
        while pressing the left button will extend the current box rather
        then erasing it and starting a new one.

        When an arrow key is pressed, the cursor is repositioned in the
        direction of the arrow key.  A repeat count is kept so that the
        longer the user holds down the arrow key, the faster it will move.
        As soon as the key is released, the repeat count is set to 1 for
        normal cursor movement.

****************************************************************************/

long FAR PASCAL __export MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
    HDC hDC;
	char fname[129];
	char title[33];
	char far *buffer;
	int hfile;
	unsigned int len;
	
    switch (message)
    {
        case WM_COMMAND:
            if (wParam == IDM_PLAY)
            {
            	fname[0]=title[0]=0;
				if( OpenFileDialog(hWnd, fname, title) ) {
					buffer = _fmalloc(50000);
					hfile= _lopen(fname, OF_READ);
					len = _lread(hfile, buffer, 49999);
					_lclose(hfile);
					IRPlay( buffer, len );
					_ffree(buffer);
				}
				break;
            }
            else if (wParam == IDM_REC)
            {
				buffer = _fmalloc(50000);
				len=49999;
				IRRecord( buffer, &len );
            	fname[0]=title[0]=0;
				if ( SaveFileDialog(hWnd, fname, title) ) {
					hfile= _lcreat(fname, 0);
					_lwrite(hfile, buffer, len);
					_lclose(hfile);
				}
				_ffree(buffer);
            	break;
			}
            else if (wParam == IDM_1)
            {
            	IRSetPort( 1 );
            	break;
			}
            else if (wParam == IDM_2)
            {
            	IRSetPort( 2 );
            	break;
			}
            else if (wParam == IDM_EXIT)
            {
            	SendMessage(hWnd, WM_CLOSE, 0, 0L);
            	break;
			} else
                return (DefWindowProc(hWnd, message, wParam, lParam));


        case WM_PAINT:
            {
                PAINTSTRUCT     ps;

                hDC = BeginPaint (hWnd, &ps);
                EndPaint (hWnd, &ps);
            }
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}


static OPENFILENAME ofn;

void OFNInit()
{
	static char *filter[] = { "All Files (*.*)", "*.*", "" };
	ofn.lStructSize=sizeof(OPENFILENAME);
	ofn.hwndOwner = 0;
	ofn.hInstance = NULL;
	ofn.lpstrFilter = filter[0];
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = NULL;
	ofn.nMaxFile = 128;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 16;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = NULL;
	ofn.Flags = 0;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = "";
	ofn.lCustData = 0L;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;
}

BOOL OpenFileDialog(HWND hWnd, LPSTR fname, LPSTR title)
{
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = fname;
	ofn.lpstrFileTitle = title;
	ofn.Flags = OFN_CREATEPROMPT;
	
	return GetOpenFileName(&ofn);
}

BOOL SaveFileDialog(HWND hWnd, LPSTR fname, LPSTR title)
{
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = fname;
	ofn.lpstrFileTitle = title;
	ofn.Flags = OFN_OVERWRITEPROMPT;
	
	return GetSaveFileName(&ofn);
}

