/*
	Computerized Infrared Remote
	Earle F. Philhower, III
	(c) 1996

	Windows 3.1 DLL Module Header
	
	Software to control the CIR hardware module.  Modifications to:
	earle@geocities.com
*/


BOOL FAR PASCAL _export IRSetPort( int num );
/*
	Sets the parallel port to which the CIR is connected.
	num: 1, 2
	ex:	IRSetPort( 1 );
*/

BOOL FAR PASCAL _export IRRecord( unsigned char far *buffer, unsigned int far *length );
/*
	Records an IR signal and stores in buffer you supply.
	buffer:  RAM space YOU allocate, up to 50,000 bytes
	length:  On input  = MAX SPACE to store (in bytes, both cases)
	         On return = size of sample recorded, always <= value on entry
	ex:	char *buffer;
		unsigned int length;
		length = 30000;
		buffer = (char *)malloc( length+1 );
		IRRecord( buffer, &length );
*/

BOOL FAR PASCAL _export IRPlay( unsigned char far *buffer, unsigned int length );
/*
	Plays back an IR signal in a buffer you supply.
	buffer:  RAM space YOU allocate, up to 50,000 bytes
	length:  Size of sample recorded (in bytes)
	ex:	char *buffer;
		buffer = (char *)malloc( 30000 );
		length = fread( buffer, 1, 30000, file );
		IRPlay( buffer, length );
*/
