/*
	Computerized Infrared Remote
	Earle F. Philhower, III
	(c) 1996

	Windows 3.1 DLL Module
		
	Software to control the CIR hardware module.  Modifications to:
	earle@geocities.com
*/

#include <windows.h>
#include <memory.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <malloc.h>

#define PPORT1 (0x378)
#define STATUS1 (PPORT1+1)

#define PPORT2 (0x278)
#define STATUS2 (PPORT2+1)

short pport=1;

#define MAXSAMPLE ((unsigned int)50000)

unsigned char data[MAXSAMPLE+1];

int FAR PASCAL _WEP(int a)
 {
       /* Your WEP functionality goes here */
  return 1;
 }


BOOL FAR PASCAL _export IRSetPort( int num )
{
	if ((num>2)||(num<1)) return FALSE;
	pport=num;
}

unsigned int Record1( unsigned char *data )
{
	unsigned int i, j, len;
	unsigned char mask, d;
	

	_disable();

	outp(PPORT1,2);
	while ((inp(STATUS1)&16)==0);
	while ((inp(STATUS1)&16)==16); /* Wait for 1st data */

	for (i=0; i<MAXSAMPLE; i++)
	{
		mask=128;
		d=0;
		for (j=0; j<8; j++)
		{
			if ((inp(STATUS1)&16)==0) d |= mask;
			mask=mask>>1;
		}
		data[i]=d;
	}

	outp(PPORT1, 0);
	_enable();

	/* Chop off ending zeros */
	for (len=MAXSAMPLE-1; len; len--)
		if (data[len]) break;

	return len;

}


unsigned int Record2( unsigned char *data )
{
	unsigned int i, j, len;
	unsigned char mask, d;
	

	_disable();

	outp(PPORT2,2);
	while ((inp(STATUS2)&16)==0);
	while ((inp(STATUS2)&16)==16); /* Wait for 1st data */

	for (i=0; i<MAXSAMPLE; i++)
	{
		mask=128;
		d=0;
		for (j=0; j<8; j++)
		{
			if ((inp(STATUS2)&16)==0) d |= mask;
			mask=mask>>1;
		}
		data[i]=d;
	}

	outp(PPORT2, 0);
	_enable();

	/* Chop off ending zeros */
	for (len=MAXSAMPLE-1; len; len--)
		if (data[len]) break;

	return len;
}

BOOL FAR PASCAL _export IRRecord( unsigned char far *buffer, unsigned int far *length )
{
	unsigned int reclen;
	
	switch( pport ) {
		case 1: reclen = Record1( data ); break;
		case 2: reclen = Record2( data ); break;
	}
	*length = min(*length, reclen);
	
	_fmemcpy( buffer, data, *length );

	return TRUE;
}	
                                 

/* Play a sample to IR port */
void Play1( unsigned char *data, unsigned int length )
{
	unsigned int i, j;
	unsigned char mask, d;
	
	_disable();
	for (i=0; i<length; i++)
	{
		mask=128;
		d=data[i];
		for (j=0; j<8; j++)
		{
			if (d&mask) outp(PPORT1, 1);
			else outp(PPORT1,0);
			
			mask=mask>>1;
		}
	}
	_enable();

	outp(PPORT1, 0);
}

void Play2( unsigned char *data, unsigned int length )
{
	unsigned int i, j;
	unsigned char mask, d;
	
	_disable();
	for (i=0; i<length; i++)
	{
		mask=128;
		d=data[i];
		for (j=0; j<8; j++)
		{
			if (d&mask) outp(PPORT2, 1);
			else outp(PPORT2,0);
			
			mask=mask>>1;
		}
	}
	_enable();

	outp(PPORT2, 0);
}

BOOL FAR PASCAL _export IRPlay( unsigned char far *buffer, unsigned int length )
{
	unsigned int reclen;
	
	reclen = min(MAXSAMPLE, length);
	_fmemcpy( data, buffer, reclen );
	switch( pport ) {
		case 1: Play1( data, reclen ); break;
		case 2: Play2( data, reclen ); break;
	}

	return TRUE;
}	



int FAR PASCAL LibMain(HANDLE hInst, WORD wDS, WORD wHS, LPSTR cmdline)
{
	if (wHS>0) UnlockData(0);
	return 1;
}
